//
//  ALMAXInterstitialAdViewController.m
//  DemoApp-ObjC
//
//  Created by Thomas So on 9/4/19.
//  Copyright © 2019 AppLovin Corporation. All rights reserved.
//

#import "ALMAXInterstitialAdViewController.h"
#import "ALBaseAdViewController.h"
//#import <Adjust/Adjust.h>
#import <AppLovinSDK/AppLovinSDK.h>

@interface ALMAXInterstitialAdViewController()<MAAdDelegate, MAAdRevenueDelegate>
@property (nonatomic, strong) MAInterstitialAd *interstitialAd;
@property (nonatomic, assign) NSInteger retryAttempt;
@end

@implementation ALMAXInterstitialAdViewController

#pragma mark - View Lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    ALSdkSettings *sdkSettings = [ALSdk shared].settings;
//    disable sequential caching of interstitials and rewarded video ad formats
    [sdkSettings setExtraParameterForKey:@"disable_b2b_ad_unit_ids" value:@"8f72bc29472ba0c5"];
    self.interstitialAd = [[MAInterstitialAd alloc] initWithAdUnitIdentifier: @"8f72bc29472ba0c5"];
    
    self.interstitialAd.delegate = self;
    self.interstitialAd.revenueDelegate = self;
    
    // Load the first ad
    [self.interstitialAd loadAd];
}

#pragma mark - IB Actions

- (IBAction)showAd
{
    if ( [self.interstitialAd isReady] )
    {
        [self.interstitialAd showAd];
    }
}

#pragma mark - MAAdDelegate Protocol

- (void)didLoadAd:(MAAd *)ad
{
    // Interstitial ad is ready to be shown. '[self.interstitialAd isReady]' will now return 'YES'
    [self logCallback: __PRETTY_FUNCTION__];
    
    // Reset retry attempt
    self.retryAttempt = 0;
}

- (void)didFailToLoadAdForAdUnitIdentifier:(NSString *)adUnitIdentifier withError:(MAError *)error
{
    [self logCallback: __PRETTY_FUNCTION__];
    
    // Interstitial ad failed to load. We recommend retrying with exponentially higher delays up to a maximum delay (in this case 64 seconds).
    
    self.retryAttempt++;
    NSInteger delaySec = pow(2, MIN(6, self.retryAttempt));
    
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, delaySec * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
        [self.interstitialAd loadAd];
    });
}

- (void)didDisplayAd:(MAAd *)ad
{
    [self logCallback: __PRETTY_FUNCTION__];
}

- (void)didClickAd:(MAAd *)ad
{
    [self logCallback: __PRETTY_FUNCTION__];
}

- (void)didHideAd:(MAAd *)ad
{
    [self logCallback: __PRETTY_FUNCTION__];
    
    // Interstitial ad is hidden. Pre-load the next ad
    [self.interstitialAd loadAd];
}

- (void)didFailToDisplayAd:(MAAd *)ad withError:(MAError *)error
{
    [self logCallback: __PRETTY_FUNCTION__];
    
    // Interstitial ad failed to display. We recommend loading the next ad
    [self.interstitialAd loadAd];
}



@end
